/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.single;

import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Single;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.SingleObserver;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.SingleOperator;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.SingleSource;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import java.util.Objects;

public final class SingleLift<T, R>
extends Single<R> {
    final SingleSource<T> source;
    final SingleOperator<? extends R, ? super T> onLift;

    public SingleLift(SingleSource<T> source, SingleOperator<? extends R, ? super T> onLift) {
        this.source = source;
        this.onLift = onLift;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super R> observer) {
        SingleObserver<? super T> sr;
        try {
            sr = Objects.requireNonNull(this.onLift.apply(observer), "The onLift returned a null SingleObserver");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        this.source.subscribe(sr);
    }
}

